/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.tasks.spi;

import com.ibm.hwmca.base.managed.BaseTower;
import com.ibm.hwmca.base.pa.GetServiceHistorySummaryData;
import com.ibm.hwmca.base.pa.ServiceHistorySummaryData;
import com.ibm.hwmca.base.pa.ServiceHistorySummaryDataElement;
import com.ibm.hwmca.base.pa.problem.CloseAllProblems;
import com.ibm.hwmca.base.pa.problem.CloseParms;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.interfaces.ServiceDataProvider;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.report.ReportListenerAdapter;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.WorkThread;
import com.ibm.hwmca.xfw.pa.tasks.XFrameServiceHistoryServerTasklet;
import com.ibm.hwmca.xfw.panel.pa.svchist.ProblemSummaryBean;
import com.ibm.hwmca.xfw.panel.pa.svchist.RepairInformationBean;
import com.ibm.hwmca.xfw.panel.pa.svchist.ServiceHistorySummaryBean;
import com.ibm.hwmca.xfw.panel.pa.svchist.ServiceHistorySummaryBeanReadOnly;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ServiceHistoryServerTasklet
extends XFrameServiceHistoryServerTasklet {
    private static final String VERSION = "Ver 1.0, Rel 0.3";
    private static final String TRACE_MASKT = "XSHSHTAT";
    private static final String TRACE_MASKF = "XSHSHTAF";
    private static final String TRACE_MASKD = "XSHSHTAD";
    private static final boolean UNIT_TEST = true;
    private HashMap _sdpMap = new HashMap(32);
    private String _workingProblem = null;
    private String _workingSystem = null;
    private boolean _readOnly = false;
    private boolean _displayedReadOnly = false;
    private static final String SERVICE_INTERFACE = "com.ibm.hwmca.fw.interfaces.ServiceDataProvider";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$interfaces$ServiceDataProvider;

    public void logException(Throwable throwable) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceHistorySummaryBean getServiceHistorySummaryBean() throws TaskletException {
        LocalizableText ans;
        Trace.trace(TRACE_MASKD, "--> getServiceHistorySummaryBean Ver 1.0, Rel 0.3");
        ServiceHistorySummaryBeanReadOnly shsb = null;
        this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "service.history.title"), new LocalizableText(BaseTextBundle.getBundleName(), "servhist.busy.text"));
        if (this.getPresentationTaskParms().getTargetIds() == null) {
            Trace.trace(TRACE_MASKD, "No targets. Running against the console.");
            try {
                Trace.trace(TRACE_MASKD, "Get the Base Tower");
                BaseTower baseTower = BaseTower.getBaseTower();
                Trace.trace(TRACE_MASKD, "got it.");
                ServiceDataProvider hmcSDP = (ServiceDataProvider)baseTower.getInterfaceImpl(class$com$ibm$hwmca$fw$interfaces$ServiceDataProvider == null ? (class$com$ibm$hwmca$fw$interfaces$ServiceDataProvider = ServiceHistoryServerTasklet.class$(SERVICE_INTERFACE)) : class$com$ibm$hwmca$fw$interfaces$ServiceDataProvider);
                Trace.trace(TRACE_MASKD, "Got the SDP =" + hmcSDP);
                if (hmcSDP == null) {
                    Trace.trace(TRACE_MASKD, "Didn't find the interface. Throw Exception");
                    throw new TaskletException("Could find the interface");
                }
                shsb = hmcSDP.getServiceHistorySummaryData(HMC.getHMC().getObjectId());
                Trace.trace(TRACE_MASKD, "back from the call");
                SystemMapping mapElement = new SystemMapping();
                mapElement._sdp = hmcSDP;
                mapElement._obId = baseTower.getObjectId();
                this._sdpMap.put(HMC.getHMC().getUIInfo().getTitle(), mapElement);
            }
            catch (Throwable thrown) {
                TaskletException ex = new TaskletException(thrown);
                Trace.trace(TRACE_MASKD, "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
                throw ex;
            }
        }
        int totalRequest = this.getPresentationTaskParms().getTargetIds().length;
        Trace.trace(TRACE_MASKD, "got " + totalRequest + " targets to handle.");
        CompletionReport[] summaryReports = new ServiceHistorySummaryData[totalRequest];
        List outerList = this.getPresentationTaskParms().getGroupedTargetIds();
        Trace.trace(TRACE_MASKD, "got an outerList of " + outerList.size() + " elements");
        ObjectId[] innerTargets = null;
        ReportListenerAdapter sumDataAdapter = new ReportListenerAdapter(this, summaryReports, this.getPresentationTaskParms().getTargetIds());
        for (int i = 0; i < outerList.size(); ++i) {
            Trace.trace(TRACE_MASKD, "Outer list set [" + i + "] data");
            innerTargets = (ObjectId[])outerList.get(i);
            for (int j = 0; j < innerTargets.length; ++j) {
                Trace.trace(TRACE_MASKD, "target id is " + innerTargets[j]);
            }
            GetServiceHistorySummaryData gSHSumData = new GetServiceHistorySummaryData(sumDataAdapter);
            Trace.trace(TRACE_MASKD, "start the work thread");
            WorkThread.invokeAsync(gSHSumData, gSHSumData, innerTargets, "Service History data gatherer thread");
        }
        try {
            Trace.trace(TRACE_MASKD, "wait for completion. State =" + String.valueOf(sumDataAdapter.isFinished()));
            ServiceHistoryServerTasklet i = this;
            synchronized (i) {
                while (!sumDataAdapter.isFinished()) {
                    try {
                        Trace.trace(TRACE_MASKD, "wait!");
                        this.wait();
                        Trace.trace(TRACE_MASKD, "wake up!!!");
                    }
                    catch (InterruptedException ie) {}
                }
            }
            Trace.trace(TRACE_MASKD, "Finshed.");
        }
        catch (Throwable thrown) {
            TaskletException ex = new TaskletException(thrown);
            Trace.trace(TRACE_MASKD, "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
            throw ex;
        }
        Trace.trace(TRACE_MASKD, "done. get the data");
        shsb = new ServiceHistorySummaryBeanReadOnly();
        for (int i = 0; i < summaryReports.length; ++i) {
            if (summaryReports[i].getCompletionCode() == CompletionReportCode.SUCCESS) {
                List repList = ((ServiceHistorySummaryData)summaryReports[i]).getList();
                String title = ManagedObjectManager.getManagedObjectManager().get(summaryReports[i].getObjectId()).getUIInfo().getTitle();
                for (int j = 0; j < repList.size(); ++j) {
                    ServiceHistorySummaryDataElement element = (ServiceHistorySummaryDataElement)repList.get(j);
                    shsb.addDataRow(element.getDate(), title, element.getProblemNumber(), element.getProblemState(), element.getProblemDescription());
                    SystemMapping mapElement = (SystemMapping)this._sdpMap.get(title);
                    if (mapElement != null) {
                        mapElement.addTime(element.getDate());
                    } else {
                        mapElement = new SystemMapping();
                        mapElement._sdp = ((ServiceHistorySummaryData)summaryReports[i]).getSdp();
                        mapElement._obId = summaryReports[i].getObjectId();
                        mapElement.addTime(element.getDate());
                        this._sdpMap.put(title, mapElement);
                    }
                    Trace.trace(TRACE_MASKD, "Dump out the map here");
                    Trace.trace(TRACE_MASKD, "early time is " + new Date(mapElement._earliestProblem));
                    Trace.trace(TRACE_MASKD, "latest time is " + new Date(mapElement._latestProblem));
                }
                continue;
            }
            Trace.trace(TRACE_MASKD, "Got a failure report for " + ManagedObjectManager.getManagedObjectManager().get(summaryReports[i].getObjectId()).getUIInfo().getTitle());
        }
        Trace.trace(TRACE_MASKD, "row count = " + shsb.getServiceHistoryTableRowCount());
        if (shsb.getServiceHistoryTableRowCount() == 0) {
            Trace.trace(TRACE_MASKD, "row count is zero");
            ans = this.showMessageBox(true, new BaseMessageText("XSH3000"), new BaseMessageText("XSH3001"), MsgType.INFORMATION_MESSAGE, null);
        }
        if (shsb.isReadOnly()) {
            if (!this._displayedReadOnly) {
                Trace.trace(TRACE_MASKD, "got a read only file");
                Trace.trace(TRACE_MASKD, "set readonly true");
                this._readOnly = true;
                ans = this.showMessageBox(true, new BaseMessageText("XSH3000"), shsb.getReadMessage(), MsgType.INFORMATION_MESSAGE, null);
                this._displayedReadOnly = true;
            }
        } else {
            Trace.trace(TRACE_MASKD, "got a read write file");
            Trace.trace(TRACE_MASKD, "set readonly false");
            this._readOnly = false;
        }
        Trace.trace(TRACE_MASKD, "<-- getServiceHistorySummaryBean ");
        this.destroyBusyDialog();
        return shsb;
    }

    public ProblemSummaryBean getProblemSummaryBean(String system, String problem) throws TaskletException {
        Trace.trace(TRACE_MASKD, "<--> getProblemSummaryBean for " + problem + " on sytem " + system);
        SystemMapping mapElement = (SystemMapping)this._sdpMap.get(system);
        ServiceDataProvider sdp = mapElement._sdp;
        ObjectId obId = mapElement._obId;
        Trace.trace(TRACE_MASKD, "system =" + system);
        Trace.trace(TRACE_MASKD, "sdp =" + sdp);
        Trace.trace(TRACE_MASKD, "sdp =" + obId);
        try {
            this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "service.history.title"), new LocalizableText(BaseTextBundle.getBundleName(), "servhist.busy.text"));
            ProblemSummaryBean psb = sdp.getProblemSummaryBean(obId, problem, system);
            this.destroyBusyDialog();
            return psb;
        }
        catch (Throwable thrown) {
            HException ex = new HException(thrown);
            Trace.trace(TRACE_MASKD, "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
            return null;
        }
    }

    public RepairInformationBean getRepairInformationBean(String system, String problem) throws TaskletException {
        Trace.trace(TRACE_MASKD, "<--> getProblemSummaryBean for " + problem + " on sytem " + system);
        SystemMapping mapElement = (SystemMapping)this._sdpMap.get(system);
        ServiceDataProvider sdp = mapElement._sdp;
        ObjectId obId = mapElement._obId;
        Trace.trace(TRACE_MASKD, "system =" + system);
        Trace.trace(TRACE_MASKD, "sdp =" + sdp);
        Trace.trace(TRACE_MASKD, "sdp =" + obId);
        try {
            this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "service.history.title"), new LocalizableText(BaseTextBundle.getBundleName(), "servhist.busy.text"));
            RepairInformationBean rib = sdp.getRepairInformationBean(obId, problem, system);
            this.destroyBusyDialog();
            if (rib == null) {
                Trace.trace(TRACE_MASKF, "got a null => no service info. put up a message");
                LocalizableText ans = this.showMessageBox(true, new BaseMessageText("XSH3000"), new BaseMessageText("XSH3003"), MsgType.INFORMATION_MESSAGE, null);
            }
            return rib;
        }
        catch (Throwable thrown) {
            HException ex = new HException(thrown);
            Trace.trace(TRACE_MASKD, "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeProblems(String[] systems, String[] problems) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-->closeProblems ");
        if (this._readOnly) {
            LocalizableText ans = this.showMessageBox(true, new BaseMessageText("XSH3000"), new BaseMessageText("XSH3004"), MsgType.INFORMATION_MESSAGE, null);
        } else {
            Trace.trace(TRACE_MASKD, "readonly not true");
        }
        Trace.trace(TRACE_MASKD, "[before sort]systems.length =" + systems.length);
        this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "service.history.title"), new LocalizableText(BaseTextBundle.getBundleName(), "servhist.close.text"));
        Arrays.sort(systems);
        Trace.trace(TRACE_MASKD, "[after sort]systems.length =" + systems.length);
        HashMap closeDataMap = new HashMap(40);
        ArrayList<String> problemList = null;
        String previousSystem = "";
        for (int i = 0; i < systems.length; ++i) {
            Trace.trace(TRACE_MASKD, "previousSyste name = [" + previousSystem + "]");
            Trace.trace(TRACE_MASKD, "current system name = " + systems[i]);
            if (systems[i].equals(previousSystem)) {
                Trace.trace(TRACE_MASKD, "still working on the same system");
                problemList.add(problems[i]);
                previousSystem = systems[i];
                continue;
            }
            Trace.trace(TRACE_MASKD, "new system to work on");
            problemList = new ArrayList<String>(20);
            problemList.add(problems[i]);
            closeDataMap.put(systems[i], problemList);
        }
        int systemCount = closeDataMap.size();
        Trace.trace(TRACE_MASKD, "Done with the sort");
        Trace.trace(TRACE_MASKD, "Got " + systemCount + " systems to work with");
        ObjectId[] anObjectArray = new ObjectId[systemCount];
        int ix = 0;
        Iterator systemNameIterator = closeDataMap.keySet().iterator();
        while (systemNameIterator.hasNext()) {
            SystemMapping mapElement = (SystemMapping)this._sdpMap.get((String)systemNameIterator.next());
            anObjectArray[ix] = mapElement._obId;
            Trace.trace(TRACE_MASKD, "anObjectArray[" + ix + "] is [" + anObjectArray[ix] + "]");
            ++ix;
        }
        CompletionReport[] compReportArray = new CompletionReport[systemCount];
        ReportListenerAdapter closeAdapter = new ReportListenerAdapter(this, compReportArray, anObjectArray);
        Trace.trace(TRACE_MASKD, "set up the close listener for " + systemCount + " systems.");
        Trace.trace(TRACE_MASKD, "compReportArray size = " + compReportArray.length);
        Trace.trace(TRACE_MASKD, "anObjectArray size = " + anObjectArray.length);
        systemNameIterator = closeDataMap.keySet().iterator();
        for (int i = 0; i < systemCount; ++i) {
            Trace.trace(TRACE_MASKD, "Working on systemMap[" + i + "]");
            if (!systemNameIterator.hasNext()) continue;
            String sysName = (String)systemNameIterator.next();
            List aProblemList = (List)closeDataMap.get(sysName);
            SystemMapping mapElement = (SystemMapping)this._sdpMap.get(sysName);
            ServiceDataProvider sdp = mapElement._sdp;
            ObjectId obId = mapElement._obId;
            Trace.trace(TRACE_MASKD, "system =" + sysName);
            Trace.trace(TRACE_MASKD, "sdp =" + sdp);
            Trace.trace(TRACE_MASKD, "objectId =" + obId);
            try {
                CloseAllProblems problemCloser = new CloseAllProblems(closeAdapter);
                CloseParms closeParms = new CloseParms();
                closeParms.setProblemList(aProblemList);
                closeParms.setOpType("LIST");
                closeParms.setSdp(sdp);
                closeParms.setObjectId(obId);
                Trace.trace(TRACE_MASKD, "start the closer work thread");
                WorkThread.invokeAsync(problemCloser, problemCloser, closeParms, "Service History closeProblems() closer work thread");
                continue;
            }
            catch (Throwable thrown) {
                TaskletException ex = new TaskletException(thrown);
                Trace.trace(TRACE_MASKD, "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
                throw ex;
            }
        }
        try {
            Trace.trace(TRACE_MASKD, "wait for completion. State =" + String.valueOf(closeAdapter.isFinished()));
            ServiceHistoryServerTasklet i = this;
            synchronized (i) {
                while (!closeAdapter.isFinished()) {
                    try {
                        Trace.trace(TRACE_MASKD, "wait!");
                        this.wait();
                        Trace.trace(TRACE_MASKD, "wake up!!!");
                    }
                    catch (InterruptedException ie) {}
                }
            }
            Trace.trace(TRACE_MASKD, "Finshed.");
        }
        catch (Throwable thrown) {
            TaskletException ex = new TaskletException(thrown);
            Trace.trace(TRACE_MASKD, "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
            throw ex;
        }
        this.destroyBusyDialog();
        Trace.trace(TRACE_MASKF, "<--closeProblems ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllProblems() throws TaskletException {
        Trace.trace(TRACE_MASKF, "-->closeAllProblems ");
        this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "service.history.title"), new LocalizableText(BaseTextBundle.getBundleName(), "servhist.close.text"));
        int systemCount = this._sdpMap.size();
        Trace.trace(TRACE_MASKD, "got " + systemCount + " systems to close problems on.");
        ObjectId[] anObjectArray = new ObjectId[systemCount];
        int ix = 0;
        Iterator valueIterator = this._sdpMap.values().iterator();
        while (valueIterator.hasNext()) {
            SystemMapping mapElement = (SystemMapping)valueIterator.next();
            anObjectArray[ix] = mapElement._obId;
            Trace.trace(TRACE_MASKD, "Target [" + ix + "] is " + anObjectArray[ix]);
            ++ix;
        }
        Trace.trace(TRACE_MASKD, "Set up the close Adapter for " + anObjectArray.length + " systems");
        CompletionReport[] compRepArray = new CompletionReport[1];
        ReportListenerAdapter closeAdapter = new ReportListenerAdapter(this, compRepArray, anObjectArray);
        valueIterator = this._sdpMap.values().iterator();
        for (int i = 0; i < systemCount; ++i) {
            Trace.trace(TRACE_MASKD, "Working on system [" + i + "]");
            if (!valueIterator.hasNext()) continue;
            SystemMapping mapElement = (SystemMapping)valueIterator.next();
            ServiceDataProvider sdp = mapElement._sdp;
            ObjectId obId = mapElement._obId;
            Trace.trace(TRACE_MASKD, "CloseAll for");
            Trace.trace(TRACE_MASKD, "sdp =" + sdp);
            Trace.trace(TRACE_MASKD, "objectId =" + obId);
            try {
                CloseAllProblems problemCloser = new CloseAllProblems(closeAdapter);
                CloseParms closeParms = new CloseParms();
                closeParms.setEndTime(mapElement._latestProblem);
                closeParms.setStartTime(mapElement._earliestProblem);
                closeParms.setOpType("ALL");
                closeParms.setSdp(sdp);
                closeParms.setObjectId(obId);
                Trace.trace(TRACE_MASKD, "start the closer work thread");
                WorkThread.invokeAsync(problemCloser, problemCloser, closeParms, "Service History closeAllProblems() closer work thread");
                continue;
            }
            catch (Throwable thrown) {
                TaskletException ex = new TaskletException(thrown);
                Trace.trace(TRACE_MASKD, "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
                throw ex;
            }
        }
        try {
            Trace.trace(TRACE_MASKD, "wait for completion. State =" + String.valueOf(closeAdapter.isFinished()));
            ServiceHistoryServerTasklet i = this;
            synchronized (i) {
                while (!closeAdapter.isFinished()) {
                    try {
                        Trace.trace(TRACE_MASKD, "wait!");
                        this.wait();
                        Trace.trace(TRACE_MASKD, "wake up!!!");
                    }
                    catch (InterruptedException ie) {}
                }
            }
            Trace.trace(TRACE_MASKD, "Finshed.");
        }
        catch (Throwable thrown) {
            TaskletException ex = new TaskletException(thrown);
            Trace.trace(TRACE_MASKD, "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
            throw ex;
        }
        this.destroyBusyDialog();
        Trace.trace(TRACE_MASKF, "<--closeAllProblems ");
    }

    public PanelBean getProblemAnalysisBean(String system, String problem) throws TaskletException {
        Trace.trace(TRACE_MASKD, "<--> getProblemAnalysisBean for " + problem + " on sytem " + system);
        SystemMapping mapElement = (SystemMapping)this._sdpMap.get(system);
        ServiceDataProvider sdp = mapElement._sdp;
        ObjectId obId = mapElement._obId;
        this._workingProblem = problem;
        this._workingSystem = system;
        Trace.trace(TRACE_MASKD, "set the working data to be system[" + this._workingSystem + "] problem " + this._workingProblem);
        try {
            this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "service.history.title"), new LocalizableText(BaseTextBundle.getBundleName(), "servhist.busy.text"));
            PanelBean pb = sdp.getProblemAnalysisBean(obId, problem, system);
            this.destroyBusyDialog();
            return pb;
        }
        catch (Throwable thrown) {
            HException ex = new HException(thrown);
            Trace.trace(TRACE_MASKD, "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
            return null;
        }
    }

    public PanelBean getServiceInformationBean() throws TaskletException {
        Trace.trace(TRACE_MASKF, "<--> getServiceInformationBean()");
        SystemMapping mapElement = (SystemMapping)this._sdpMap.get(this._workingSystem);
        ServiceDataProvider sdp = mapElement._sdp;
        ObjectId obId = mapElement._obId;
        UserContext userContext = UserContext.getCurrentUserContext();
        boolean ceMode = false;
        if (User.getUser().hasAuth("base.rolegroup.pedebug")) {
            Trace.trace(TRACE_MASKD, "pe mode");
            ceMode = true;
        }
        if (User.getUser().hasAuth("base.rolegroup.service")) {
            Trace.trace(TRACE_MASKD, "ce mode");
            ceMode = true;
        }
        try {
            this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "service.history.title"), new LocalizableText(BaseTextBundle.getBundleName(), "servhist.busy.text"));
            PanelBean pb = null;
            if (ceMode) {
                Trace.trace(TRACE_MASKD, "get the ce mode panel");
                pb = sdp.getServiceInformationBeanCE(obId, this._workingProblem, this._workingSystem);
            } else {
                pb = sdp.getServiceInformationBeanOperator(obId, this._workingProblem, this._workingSystem);
            }
            this.destroyBusyDialog();
            return pb;
        }
        catch (Throwable thrown) {
            TaskletException ex = new TaskletException(thrown);
            Trace.trace(TRACE_MASKD, "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
            throw ex;
        }
    }

    static String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        throwable.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class SystemMapping {
        public ObjectId _obId = null;
        public ServiceDataProvider _sdp = null;
        public long _earliestProblem = Long.MAX_VALUE;
        public long _latestProblem = Long.MIN_VALUE;

        SystemMapping() {
        }

        public void addTime(Date aDate) {
            long _theTime = aDate.getTime();
            if (this._earliestProblem > _theTime) {
                Trace.trace(ServiceHistoryServerTasklet.TRACE_MASKD, "set _earliestProblem to the passed time");
                this._earliestProblem = _theTime;
            }
            if (this._latestProblem < _theTime) {
                Trace.trace(ServiceHistoryServerTasklet.TRACE_MASKD, "set _latestProblem to the passed time");
                this._latestProblem = _theTime;
            }
        }
    }
}

